<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/


class XenCentral_AdServer_AttachmentHandler_Banner extends XenForo_AttachmentHandler_Abstract
{
	protected $_bannerModel = null;
	protected $_zoneModel = null;

	/**
	 * Key of primary content in content data array.
	 *
	 * @var string
	 */
	protected $_contentIdKey = 'bannerId';

	/**
	 * Route to get to the banner
	 *
	 * @var string
	 */
	protected $_contentRoute = 'ads/banner/edit';

	/**
	 * Name of the phrase that describes the conversation_message content type
	 *
	 * @var string
	 */
	protected $_contentTypePhraseKey = 'xcas_banner';

	/**
	 * Determines if attachments and be uploaded and managed in this context.
	 *
	 * @see XenForo_AttachmentHandler_Abstract::_canUploadAndManageAttachments()
	 */
	protected function _canUploadAndManageAttachments(array $contentData, array $viewingUser)
	{
		if(!isset($contentData['zone_id'])) {
			$banner=$this->_getBannerModel()->getBannerById($contentData['content_id']);
			$zone=$this->_getZoneModel()->getZoneByIdFromCache($banner['zoneId']);
		} else {
			$zone = $this->_getZoneModel()->getZoneByIdFromCache($contentData['zone_id']);
		}

		XenForo_Application::set('requestZoneId', $zone['zoneId']);
		XenForo_Application::set('requestZone', $zone);


		if($zone->isCustomZone() && $zone->isZoneOwner($viewingUser['user_id'])) {
			return true;
		}

		if($zone->isUserZone() && XenCentral_AdServer_Permissions::canCreateBanner()) {
			return true;
		}

		if(XenForo_Model::create('XenForo_Model_User')->isUserSuperAdmin($viewingUser)) {
			return true;
		}

		if ($viewingUser['is_admin']) {
			$adminPermissions = XenForo_Model::create('XenForo_Model_Admin')->getAdminPermissionCacheForUser(
					$viewingUser['user_id']
			);
			if ($adminPermissions && !empty($adminPermissions['xcas_manage_ads'])) {
				return true;
			}
		}

		return false;
	}

	/**
	 * Determines if the specified attachment can be viewed.
	 *
	 * @see XenForo_AttachmentHandler_Abstract::_canViewAttachment()
	 */
	protected function _canViewAttachment(array $attachment, array $viewingUser)
	{
		return true;
	}

	/**
	 * Code to run after deleting an associated attachment.
	 *
	 * @see XenForo_AttachmentHandler_Abstract::attachmentPostDelete()
	 */
	public function attachmentPostDelete(array $attachment, Zend_Db_Adapter_Abstract $db)
	{
		$attachId = $db->quote($attachment['attachment_id']);

		$this->_getBannerModel()->deleteAttachmentFile($attachment);
		$this->_getBannerModel()->updateBannerImages($attachment['content_id']);
	}
    
    /**
	 * @return XenCentral_AdServer_Model_Banner
	 */
	protected function _getBannerModel()
	{
		if (!$this->_bannerModel)
		{
			$this->_bannerModel = XenForo_Model::create('XenCentral_AdServer_Model_Banner');
		}

		return $this->_bannerModel;
	}

	/**
	 * @return XenCentral_AdServer_Model_Zone
	 */
	protected function _getZoneModel()
	{
		if (!$this->_zoneModel)
		{
			$this->_zoneModel = XenForo_Model::create('XenCentral_AdServer_Model_Zone');
		}

		return $this->_zoneModel;
	}

	/**
	 * Get attachment constraints for the current attachment content type
	 *
	 * @return array
	 */
	public function getAttachmentConstraints()
	{
		if(!XenForo_Application::isRegistered('requestZoneId')) {
			throw new XenForo_Exception("Banner attachments constrains require zone ID to be defined.");
		}

		$zone=$this->_getZoneModel()->getZoneByIdFromCache(XenForo_Application::get('requestZoneId'));
		return $this->_getBannerModel()->getUploadConstraints($zone);
	}
}